DECLARE
  CURSOR employee_cursor IS
    SELECT first_name || ' ' || last_name AS full_name, salary
    FROM employees;
    
  l_employee employee_cursor%ROWTYPE;

BEGIN
  OPEN employee_cursor;
  
  LOOP
    FETCH employee_cursor INTO l_employee;
    EXIT WHEN employee_cursor%NOTFOUND;
    DBMS_OUTPUT.PUT_LINE(
      RPAD(l_employee.full_name, 50) || ': ' || 
      to_char(l_employee.salary, '$99,999')
    );
  END LOOP;
  
  CLOSE employee_cursor;
END;