DECLARE
  CURSOR employee_cursor(min_salary NUMBER) IS
    SELECT first_name || ' ' || last_name AS full_name, salary
    FROM employees
    WHERE salary >= min_salary;

BEGIN
  
  FOR l_employee IN employee_cursor(10000) LOOP
    DBMS_OUTPUT.PUT_LINE(
      RPAD(l_employee.full_name, 50) || ': ' || 
      to_char(l_employee.salary, '$99,999')
    );
  END LOOP;
  
END;