-- Create procedure
CREATE OR REPLACE PROCEDURE drop_department(
  department_id_in  IN    departments.department_id%TYPE,
  num_layoffs_out   OUT   NUMBER
) IS
  no_such_department EXCEPTION;
BEGIN

  UPDATE departments
  SET manager_id = NULL
  WHERE department_id = department_id_in;
  
  IF SQL%NOTFOUND THEN
    RAISE no_such_department;
  END IF;

  DELETE FROM employees
  WHERE department_id = department_id_in;
  
  num_layoffs_out := SQL%ROWCOUNT;

  DELETE FROM departments
  WHERE department_id = department_id_in;

EXCEPTION
  WHEN no_such_department THEN
    RAISE_APPLICATION_ERROR(-20101,
                    'No department with id ' || department_id_in);
  
END drop_department;

-- Call procedure
DECLARE
  l_department_id departments.department_id%TYPE := 100;
  l_num_layoffs   NUMBER(6,0);
BEGIN
  drop_department(
    department_id_in  => l_department_id,
    num_layoffs_out   => l_num_layoffs
  );
  DBMS_OUTPUT.PUT_LINE(l_num_layoffs || ' employees laid off.');
EXCEPTION
  WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'An error was encountered - ' ||
                                    SQLCODE ||
                                    ' -ERROR- ' ||
                                    SQLERRM, TRUE);
END;