CREATE OR REPLACE PROCEDURE check_rights(
  birth_date_in  IN  DATE,
  has_license_in IN  BOOLEAN
)
IS
  l_age NUMBER(6,2);
BEGIN
  l_age := get_age(birth_date_in);
  IF l_age >= 21 AND has_license_in THEN
    DBMS_OUTPUT.PUT_LINE('You can drive and drink, ' ||
      'but don''t drink and drive.');
  ELSIF l_age >= 21 THEN
    DBMS_OUTPUT.PUT_LINE('You can drink, but cannot drive.');
  ELSIF l_age >= 16 AND has_license_in THEN
    DBMS_OUTPUT.PUT_LINE('You can drive, but cannot drink.');
  ELSIF has_license_in THEN -- Must be younger than 16
    DBMS_OUTPUT.PUT_LINE('How did you get your license so young?');
  ELSE -- Younger than 16 and no license
    DBMS_OUTPUT.PUT_LINE('You cannot drink or drive.');
  END IF;
END check_rights;

DECLARE
  l_birth_date DATE;
  l_has_license BOOLEAN;
BEGIN
  l_birth_date := TO_DATE('1986-06-03', 'YYYY-MM-DD');
  l_has_license := FALSE;
  check_rights(l_birth_date, l_has_license);
END;