-- Create the procedure
CREATE OR REPLACE PROCEDURE replace_head_honcho(
  new_head_honcho_id_in      IN    employees.employee_id%TYPE,
  old_head_honcho_id_in      IN    employees.employee_id%TYPE
) IS
  l_new_head_manager_id   employees.manager_id%TYPE;
  l_old_head_manager_id   employees.manager_id%TYPE;
  l_new_head_honcho_name  VARCHAR2(50);
  l_old_head_honcho_name  VARCHAR2(50);
BEGIN
  
  SELECT manager_id
  INTO l_new_head_manager_id
  FROM employees
  WHERE employee_id = new_head_honcho_id_in;
  
  SELECT manager_id
  INTO l_old_head_manager_id
  FROM employees
  WHERE employee_id = old_head_honcho_id_in;
  
  SELECT first_name || ' ' || last_name
  INTO l_new_head_honcho_name
  FROM employees
  WHERE employee_id = new_head_honcho_id_in;
  
  SELECT first_name || ' ' || last_name
  INTO l_old_head_honcho_name
  FROM employees
  WHERE employee_id = old_head_honcho_id_in;

  -- when the new head manager is already a head manager
      DBMS_OUTPUT.PUT_LINE(l_new_head_honcho_name ||
                        '(employee_id: ' || new_head_honcho_id_in ||
                        ') is already a head honcho.');
                        
  -- when the old head manager is not actually a head manager
      DBMS_OUTPUT.PUT_LINE(l_old_head_honcho_name ||
                        '(employee_id: ' || old_head_honcho_id_in ||
                        ') is not a head honcho.');
  -- otherwise
      -- New head honcho should not report to anyone
      UPDATE employees
      SET manager_id = NULL
      WHERE employee_id = new_head_honcho_id_in;
      
      -- Old head honcho should report to new head honcho
      UPDATE employees
      SET manager_id = new_head_honcho_id_in
      WHERE employee_id = old_head_honcho_id_in;
      
      DBMS_OUTPUT.PUT_LINE(l_old_head_honcho_name ||
                          ' now reports to ' ||
                          l_new_head_honcho_name || '.');
      
      DBMS_OUTPUT.PUT_LINE(l_new_head_honcho_name ||
                          ' is new head honcho.');

  
END replace_head_honcho;

-- Call the procedure
DECLARE
  l_new_head_honcho_id     employees.employee_id%TYPE  :=  102;
  l_old_head_honcho_id     employees.manager_id%TYPE   :=  100;
BEGIN
  replace_head_honcho(
    new_head_honcho_id_in  => l_new_head_honcho_id,
    old_head_honcho_id_in  => l_old_head_honcho_id
  );
END;