CREATE OR REPLACE FUNCTION num_reports(
  employee_id_in IN  employees.employee_id%TYPE  := NULL,
  first_name_in  IN  employees.first_name%TYPE   := NULL,
  last_name_in   IN  employees.last_name%TYPE    := NULL
)
 RETURN NUMBER
IS
  l_num_rpts NUMBER;
BEGIN
  IF employee_id_in IS NOT NULL THEN  
    SELECT COUNT(employee_id)
    INTO l_num_rpts
    FROM employees
    WHERE manager_id = employee_id_in;
  ELSE
    SELECT COUNT(employee_id)
    INTO l_num_rpts
    FROM employees
    WHERE manager_id = (
      SELECT employee_id
      FROM employees
      WHERE first_name = first_name_in
        AND last_name = last_name_in);
  END IF;
    
  RETURN l_num_rpts;
END num_reports;