CREATE OR REPLACE FUNCTION get_quarter(
  date_in IN DATE
)
  RETURN NUMBER
IS
  l_m CHAR(3);
BEGIN
  l_m := TO_CHAR(date_in, 'Mon');
  IF l_m IN ('Jan','Feb','Mar') THEN
    RETURN 1;
  ELSIF l_m IN ('Apr','May','Jun') THEN
    RETURN 2;
  ELSIF l_m IN ('Jul','Aug','Sep') THEN
    RETURN 3;
  ELSE
    RETURN 4;
  END IF;
END get_quarter;

DECLARE
  l_the_date  DATE;
  l_quarter   NUMBER(1,0);
BEGIN
  l_the_date  := CURRENT_DATE;
  l_quarter   := get_quarter(l_the_date);
  DBMS_OUTPUT.PUT_LINE(l_quarter);
END;