-- Create function
CREATE OR REPLACE FUNCTION get_manager_of_dpt_or_emp(
  id_in         IN    VARCHAR2,
  key_in        IN    VARCHAR2
)
 RETURN VARCHAR2
IS
  l_manager_name  VARCHAR2(50);
BEGIN
  CASE key_in
    WHEN 'emp' THEN
      SELECT first_name || ' ' || last_name
      INTO l_manager_name
      FROM employees
      WHERE employee_id = (
        SELECT manager_id
        FROM employees
        WHERE employee_id = id_in);
    WHEN 'dpt' THEN
      SELECT first_name || ' ' || last_name
      INTO l_manager_name
      FROM employees
      WHERE employee_id = (
        SELECT manager_id
        FROM departments
        WHERE manager_id = id_in);
    ELSE
      l_manager_name := NULL;
  END CASE;
  
  RETURN l_manager_name;
END get_manager_of_dpt_or_emp;

-- Call function
SELECT get_manager_of_dpt_or_emp(110, 'emp') FROM DUAL;
SELECT get_manager_of_dpt_or_emp(200, 'dpt') FROM DUAL;