-- Names of all employees who report to Gerald Cambrault
SELECT first_name, last_name
FROM employees
WHERE manager_id = (SELECT employee_id
                    FROM employees
                    WHERE last_name = 'Cambrault'
                      AND first_name = 'Gerald');

-- Departments not in the United States (knowing country_id)
SELECT department_name
FROM departments
WHERE location_id NOT IN
      (
        SELECT location_id
        FROM locations
        WHERE country_id = 'US'
      );

-- Departments not in the United States (w/o knowing country_id)
SELECT department_name
FROM departments
WHERE location_id NOT IN
      (
        SELECT location_id
        FROM locations
        WHERE country_id =
            (
              SELECT country_id
              FROM countries
              WHERE country_name = 'United States of America'
            )
      );