SELECT job_id
FROM employees
WHERE first_name = 'Steven' AND last_name = 'King';

SELECT job_title
FROM jobs
WHERE job_id = 'AD_PRES';

SELECT job_title
FROM jobs
WHERE job_id = (
          SELECT job_id
          FROM employees
          WHERE first_name = 'Steven' AND last_name = 'King'
        );

-- This will error: single-row subquery returns more than one row
SELECT job_title
FROM jobs
WHERE job_id = (
          SELECT job_id
          FROM employees
          WHERE last_name = 'King'
        );

-- To fix the query above, use IN...
SELECT job_title, job_id, min_salary, max_salary
FROM jobs
WHERE job_id IN (
          SELECT job_id
          FROM employees
          WHERE last_name = 'King'
        );