-- Compare each employee's salary with the average
-- salary of all employees
SELECT first_name, last_name, job_id, salary,
  (
    SELECT ROUND(AVG(salary))
    FROM employees
  ) AS avg_salary
FROM employees;

-- Compare each employee's salary with the average
-- salary of all employees with the same job
SELECT first_name, last_name, job_id, salary,
  (
    SELECT ROUND(AVG(salary))
    FROM employees e2
    WHERE e1.job_id=e2.job_id
  ) AS avg_salary_job
FROM employees e1;

-- Only get those who earn more than
-- their colleagues with the same job
SELECT first_name, last_name, job_id, salary,
  (
    SELECT ROUND(AVG(salary))
    FROM employees e2
    WHERE e1.job_id=e2.job_id
  ) AS avg_salary_job
FROM employees e1
WHERE salary > (
    SELECT ROUND(AVG(salary))
    FROM employees e2
    WHERE e1.job_id=e2.job_id
  );

-- Show how much more they earn than their
-- colleagues with the same job
SELECT first_name, last_name, job_id, salary,
  (
    SELECT ROUND(AVG(salary))
    FROM employees e2
    WHERE e1.job_id=e2.job_id
  ) AS avg_salary_job,
  salary - (
    SELECT ROUND(AVG(salary))
    FROM employees e2
    WHERE e1.job_id=e2.job_id
  ) AS earning_diff
FROM employees e1
WHERE salary > (
    SELECT ROUND(AVG(salary))
    FROM employees e2
    WHERE e1.job_id=e2.job_id
  )
ORDER BY earning_diff DESC;