-- Number of clients
SELECT COUNT(*) FROM clients; -- 128

-- Number of vendors
SELECT COUNT(*) FROM vendors; -- 90

-- All clients and vendors without duplicates 
SELECT first_name, last_name, email, phone_number
FROM clients
UNION
SELECT first_name, last_name, email, phone_number
FROM vendors
ORDER BY last_name, first_name;

-- All clients and vendors with duplicates 
SELECT first_name, last_name, email, phone_number
FROM clients
UNION ALL
SELECT first_name, last_name, email, phone_number
FROM vendors
ORDER BY last_name, first_name;

-- All clients who are also vendors 
SELECT first_name, last_name, email, phone_number
FROM clients
INTERSECT
SELECT first_name, last_name, email, phone_number
FROM vendors
ORDER BY last_name, first_name;

-- All clients except those that are also vendors
SELECT first_name, last_name, email, phone_number
FROM clients
MINUS
SELECT first_name, last_name, email, phone_number
FROM vendors
ORDER BY last_name, first_name;

-- All vendors except those that are also clients
SELECT first_name, last_name, email, phone_number
FROM vendors
MINUS
SELECT first_name, last_name, email, phone_number
FROM clients
ORDER BY last_name, first_name;