--How long employed
SELECT first_name, last_name, hire_date,
  ROUND(current_date - hire_date)
    || ' days' AS days_employed,
  ROUND((current_date - hire_date) / 365.25, 2)
    || ' years' AS years_employed
FROM employees;

-- Revolutionary War: April 19, 1775 - September 3, 1783
SELECT TO_DATE('04-19-1775', 'MM-DD-YYYY') AS war_starts,
  TO_DATE('09-03-1783', 'MM-DD-YYYY') AS war_ends,
  TO_DATE('09-03-1783', 'MM-DD-YYYY')
    - TO_DATE('04-19-1775', 'MM-DD-YYYY') AS days_of_war,
  (TO_DATE('09-03-1783', 'MM-DD-YYYY')
    - TO_DATE('04-19-1775', 'MM-DD-YYYY')) / 365.25 AS years_of_war,
  TRUNC(
    (TO_DATE('09-03-1783', 'MM-DD-YYYY')
    - TO_DATE('04-19-1775', 'MM-DD-YYYY')) / 365.25
  ) AS years_only,
  MOD(TO_DATE('09-03-1783', 'MM-DD-YYYY')
    - TO_DATE('04-19-1775', 'MM-DD-YYYY'), 365.25)
      AS and_days
FROM DUAL;

SELECT first_name, last_name, TO_CHAR(hire_date, 'Day') AS hire_day
FROM employees
ORDER BY TO_CHAR(hire_date, 'D');