SELECT employee_id, first_name, last_name, hire_date,
  ROW_NUMBER() OVER (ORDER BY hire_date) AS row_num
FROM employees
ORDER BY row_num;

-- Same as above, but with main ORDER BY clause removed
SELECT employee_id, first_name, last_name, hire_date,
  ROW_NUMBER() OVER (ORDER BY hire_date) AS row_num
FROM employees;

-- Same as above, but ordering by a different field
SELECT employee_id, first_name, last_name, hire_date,
  ROW_NUMBER() OVER (ORDER BY hire_date) AS row_num
FROM employees
ORDER BY last_name;