SELECT department_id, department_name, manager_id, location_id
FROM departments;

-- No table aliases
SELECT departments.department_name,
  employees.first_name || ' ' || employees.last_name AS manager
FROM departments
  JOIN employees ON employees.employee_id = departments.manager_id;

-- The same query using table aliases
SELECT d.department_name,
  e.first_name || ' ' || e.last_name AS manager
FROM departments d
  JOIN employees e ON e.employee_id = d.manager_id;