-- Dept ids of small departments
SELECT d.department_id, d.department_name,
  COUNT(e.employee_id) AS num_employees 
FROM departments d 
  JOIN employees e ON d.department_id = e.department_id 
GROUP BY d.department_id, d.department_name 
HAVING COUNT(e.employee_id) <= 3;

-- Count them up
SELECT COUNT(employee_id) AS num_employees
FROM employees 
WHERE department_id IN (110, 70, 90, 10, 20, 40);

-- Query to be used as inline view
SELECT d.department_name,
  COUNT(e.employee_id) AS num_employees 
FROM departments d
  JOIN employees e ON d.department_id = e.department_id
GROUP BY d.department_name

-- Total number of employees in small departments
SELECT SUM(num_employees) AS num_employees
FROM
(
  SELECT d.department_name,
    COUNT(e.employee_id) AS num_employees 
  FROM departments d
    JOIN employees e ON d.department_id = e.department_id
  GROUP BY d.department_name
)
WHERE num_employees <= 3;