SELECT e.first_name, e.last_name, e.salary, j.job_title,
  CASE
    WHEN e.salary > (j.max_salary + j.min_salary) / 2
      THEN 'Above Midpoint'
    WHEN e.salary < (j.max_salary + j.min_salary) / 2
      THEN 'Below Midpoint'
    ELSE 'Midpoint'
  END AS salary_status
FROM employees e
  JOIN jobs j ON j.job_id = e.job_id
ORDER BY e.last_name, e.first_name;