SELECT manager_id, job_id, COUNT(*) AS num_employees
FROM employees
WHERE manager_id IS NOT NULL
GROUP BY manager_id, job_id
ORDER BY manager_id, job_id;

SELECT manager_id, job_id, COUNT(*) AS num_employees
FROM employees
WHERE manager_id IS NOT NULL
GROUP BY ROLLUP(manager_id, job_id)
ORDER BY manager_id, job_id;

SELECT COALESCE(TO_CHAR(manager_id), '** All Managers') AS manager_id, 
  COALESCE(job_id, '** All Jobs') AS job_id, 
  COUNT(*) AS num_employees
FROM employees
WHERE manager_id IS NOT NULL
GROUP BY ROLLUP(manager_id, job_id)
ORDER BY manager_id, job_id;

SELECT manager_id, job_id, COUNT(*) AS num_employees
FROM employees
WHERE manager_id IS NOT NULL
GROUP BY CUBE(manager_id, job_id)
ORDER BY manager_id, job_id;

SELECT COALESCE(TO_CHAR(manager_id), '** All Managers') AS manager_id, 
  COALESCE(job_id, '** All Jobs') AS job_id,
  COUNT(*) AS num_employees
FROM employees
WHERE manager_id IS NOT NULL
GROUP BY CUBE(manager_id, job_id)
ORDER BY manager_id, job_id;