import employees.*;
import util.*;
import java.util.*;
import java.io.*;

public class Payroll {  
    public static void main(String[] args) {

        List<Employee> employees = new ArrayList<>();
        String fName = null;
        String lName = null;
        int dept = 0;
        double payRate = 0.0;
        double hours = 0.0;

        //TODO:  declare and instantiate a File object for "employees.ser"
        File empData = new File("employees.ser");

        //TODO: if the file exists
        if (empData.exists()) {
            //TODO: declare an ObjectInputStream variable and initialize it to null
            ObjectInputStream fIn = null;
            //TODO: in a try block, pass a new FileInputStream that uses the File object  
            //      to the ObjectInputStream constructor
        try {
                fIn = new ObjectInputStream(new FileInputStream(empData));
                //TODO: read the next id that was stored
                int nextId = fIn.readInt();
                System.out.println("Read nextId: " + nextId);
                //      Read the next object
                //      This object should be a List otherwise throw an Exception
                //      
                Object value = fIn.readObject();
                if (value instanceof List) {
                    employees=(List)value;
                    System.out.println("Number of employees is " + employees.size());
                } 
                else {
                    throw new Exception("Object is not a list!");
                }
            } catch (Exception ex) {
                    ex.getMessage();
            }
        //TODO: if the file doesn't exist, prompt user for employee data
        } 
        else {
            for (;;) {
                char type = 
                    KeyboardReader.getPromptedChar("Enter type: E, N, or C or Q: ");
                if (type == 'Q'  || type == 'q') {
                    break;
                }
                if (type != 'e' && type != 'E' && 
                        type != 'n' && type != 'N' && 
                        type != 'c' && type != 'C') {
                    System.out.println("Please enter a valid type");
                    continue;        
                }
                fName = KeyboardReader.getPromptedString("Enter first name: ");
                lName = KeyboardReader.getPromptedString("Enter last name: ");
                dept = KeyboardReader.getPromptedInt("Enter department: ");
                do {
                    payRate = KeyboardReader.getPromptedDouble("Enter pay rate: ");
                    if (payRate < 0.0) {
                        System.out.println("Pay rate must be >= 0");
                    }
                } while (payRate < 0.0);

                switch (type) {
                    case 'e':
                    case 'E': 
                        employees.add(new ExemptEmployee(fName, lName, dept, payRate));
                        break;
                    case 'n':
                    case 'N': 
                        do {
                            hours = KeyboardReader.getPromptedDouble("Enter hours: ");
                            if (hours < 0.0) {
                                System.out.println("Hours must be >= 0");
                            }
                        } while (hours < 0.0);
                        employees.add(new NonexemptEmployee(fName,lName,dept,payRate,hours));
                        break;
                    case 'c':
                    case 'C': 
                        do {
                            hours = KeyboardReader.getPromptedDouble("Enter hours: ");
                            if (hours < 0.0) {
                                System.out.println("Hours must be >= 0");
                            }
                        } while (hours < 0.0);
                        employees.add(new ContractEmployee(fName,lName,dept,payRate,hours));
                }
            }
        }

        //TODO: define and initialize an ObjectOutputStream object
        ObjectOutputStream fOut = null;
        //TODO: in a try block, create the ObjectOutputStream object
        try {
            fOut = new ObjectOutputStream(new FileOutputStream(empData));
            //TODO:  write the current Employee next id
            fOut.writeInt(Employee.getNextId());
            //TODO: write the ArrayList of employee objects
            fOut.writeObject(employees);
            //TODO: close the ObjectOutputStream object
            fOut.close();
        } 
        //TODO: catch exceptions
        catch (Exception ex) {
            ex.getMessage();
        }
        System.out.println();
        System.out.println("Exempt Employees");
        System.out.println("====== =========");
        for (Employee emp : employees) {
            if (emp instanceof ExemptEmployee) {
               System.out.println(emp.getPayInfo());
            }
        }
        System.out.println();
        System.out.println("Nonexempt Employees");
        System.out.println("========= =========");
        for (Employee emp : employees) {
            if (emp instanceof NonexemptEmployee) {
                System.out.println(emp.getPayInfo());
            }
        }
        System.out.println();
        System.out.println("Contract Employees");
        System.out.println("======== =========");
        for (Employee emp : employees) {
            if (emp instanceof ContractEmployee) {
                System.out.println(emp.getPayInfo());
            }
        }
    }
}