import java.io.*;

public class FileList {

  public static void main(String[] args) {
    listContents(".");
  }

  private static void listContents(String dir) {
    File directory = new File(dir);
    if (directory == null) {
      System.out.println("Directory not found");
      return;
    }
    System.out.println("Directory listing for " + directory.getAbsolutePath());
    File[] contents = directory.listFiles(
            new FileFilter() {
              public boolean accept(File path) {
                return path.getName().endsWith(".txt") || path.isDirectory();
              }
            });
    for (File file : contents) {
      System.out.format("%-30s %-10s%n",
              file.getName(),
              file.isDirectory() ? "Directory" : "File");
    }
  }
}