import java.io.Console;
import java.util.Date;

public class TestConsole {
  public static void main(String[] args) {
    Console console = System.console();
    
    // using unformatted I/O
    String name = console.readLine("What is your name? ");
    console.printf("Hello, " + name + "\n\n");

    // using formatted I/O
    int age = Integer.parseInt(
        console.readLine("Tell me %s, how old are you? ", name));
    console.printf("Wow, you don't look a day over %d!%n%n", age - 10);
    
    // using formatted date/time
    console.printf("Today is %tD%nand it is now %tr%n%n",
        new Date(), new Date());
    
    // using argument order indicators
    console.printf("Today is %1$tD%nand it is now %1$tr%n%n",
        new Date());
    
  }
}