/**
 *  Represents a Book in inventory,with an item code and a price
 */
public class BookWithJavadoc {

/**
  * The book's item code
 */
  private int itemCode;

/**
 * The title of the book
 */
  private String title;

/**
 * Creates a book instance.
 * @param itemCode the book's item code.  It is expected
 *  that the value will be non-negative; a negative value
 *  will be rejected.
 * @param title the title of the book
 */
  public BookWithJavadoc(int itemCode, String title) {
    setItemCode(itemCode);
    setTitle(title);
  }

/**
 * Creates a book instance,  The item code will be set to 0.
 * @param title the title of the book
 */
  public BookWithJavadoc(String title) {
    setItemCode(0);
    setTitle(title);
  }

/**
 * Retrieves the item code for the book.
 * @return the book's item code
 */
  public int getItemCode() {
    return itemCode;
  }

/**
 * Sets the item code for the book.  It is expected that the value will
 *  be non-negative; a negative value will be rejected.
 * @param itemCode the book's item code
 */
  public void setItemCode (int itemCode) {
    if (itemCode > 0) this.itemCode = itemCode; 
  }

/**
 * Retrieves the title of the book.
 * @return the title of the book
 */
  public String getTitle() {
    return title;
  }

/**
 * Sets the title of the book.
 * @param title the title of the book
 */
  public void setTitle (String title) {
    this.title = title;
  }
  public void display() {
    System.out.println(itemCode + " " + title);
  }
}