package service;
import java.util.Date;

import util.annotation.ConsoleMethod;
import util.annotation.ConsoleParam;
import util.annotation.ConsoleService;

@ConsoleService(serviceName="DateTimeService")
public class AnnotatedConsoleService {
  
  @ConsoleMethod
  public Date getDate() {
    return new Date();
  }

  @ConsoleMethod
  public Date getFutureDate(
        @ConsoleParam(name="days") String daysOffset) {
    Date d = new Date();
    d.setDate(d.getDate() + Integer.parseInt(daysOffset));
    return d;
  }
  
  public void someOtherMethod() {
    System.out.println("A non-service method");
  }
}
