import java.util.List;

import util.KeyboardReader;

public class UseConsoleService {
  
  public static void main(String[] args) {
    
    Object service;
    List<String> availableMethods;
    
    // below could be obtained dynamically
    String serviceName = "service.AnnotatedConsoleService";
    
    try {
      service = Class.forName(serviceName).newInstance();
      ConsoleServer server = new ConsoleServer();     
      server.load(service);
      
      availableMethods = server.listMethods();
      System.out.println("Available methods:");
      for (String method : availableMethods)
        System.out.println("  " + method);
      String methodToRun = 
        KeyboardReader.getPromptedString("Enter method to run: ");
        
      if (availableMethods.contains(methodToRun)) {
        String paramName = server.getParamForMethod(methodToRun);
        if (paramName != null) {
          String param = 
            KeyboardReader.getPromptedString("Enter " + paramName + ":");
          System.out.println(server.run(methodToRun, param));
        } else {
          System.out.println(server.run(methodToRun));
        }
        
      } else {
        System.out.println("Method not found");
      }
      
    } catch (InstantiationException e) {
      e.printStackTrace();
    } catch (IllegalAccessException e) {
      e.printStackTrace();
    } catch (ClassNotFoundException e) {
      e.printStackTrace();
    }
    
  }
}