import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

public class ProcessPayroll {
    class PayrollRecord {
        String employeeName;
        double hrsWorked;
        int payGrade;
        PayrollRecord (String employeeName, double hrsWorked, int payGrade) {
            this.employeeName = employeeName;
            this.hrsWorked = hrsWorked;
            this.payGrade = payGrade;
        }
    }
    public static void main (String[] args) {

        PayrollRecord[] records =
                { 	new ProcessPayroll().new PayrollRecord("Bill Jones", 35.5, 1),
                        new ProcessPayroll().new PayrollRecord("Sally Zahn", 40.0, 2),
                        new ProcessPayroll().new PayrollRecord("Chris Carlton", 37.5, 2),
                        new ProcessPayroll().new PayrollRecord("Emily Wyatt", 30.0, 1),
                        new ProcessPayroll().new PayrollRecord("Perky Peterson", 28.0, 1)
                };

        double payAmount = 0;
        DecimalFormat sdf = new DecimalFormat("$###,###.00");
        for (PayrollRecord record : records) {
            if (record.payGrade == 1) {
                payAmount = record.hrsWorked * 25.00;
            }
            else if (record.payGrade == 2) {
                payAmount = record.hrsWorked * 30.00;
            }
            else {
                System.out.println("Invalid pay grade for " + record.employeeName);
            }

            System.out.printf("Payment for %s is %s%n", record.employeeName, sdf.format(payAmount));
        }
    }
}