public class UsedBookWithEnum extends BookWithEnum {
  private Condition condition;
  
  public enum Condition {  
    
    excellent(0.0), good(0.25), fair(0.5), poor(0.7);

    private double discount;
    
    Condition(double discount) {
      this.discount = discount;
    }
    
    public double getDiscountedPrice(UsedBookWithEnum book) {
      return book.getPrice() * (1 - discount);
    }
    
  };
    
  public UsedBookWithEnum(
        int itemCode, String title, double price, 
        Category category,
        Condition condition) {
    super(itemCode, title, price, category);
    setCondition(condition);
  }
  public Condition getCondition() {
    return condition;
  }
  public void setCondition(Condition condition) {
    this.condition = condition;
  }
  public void setCondition(String condition) {
    this.condition = Condition.valueOf(condition);
  }
  public void display() {
    System.out.println(getItemCode() + " " + getTitle() + 
          ": " + getCategory() +
          ", condition: " + getCondition() +
          ", List price: " + getPrice() +
          ", Discounted price: " + condition.getDiscountedPrice(this));
  }
}