public class UseBookWithEnum {
  public static void main(String[] args) {
    BookWithEnum b = new BookWithEnum(
          5011, "Fishing Explained", 25.0, 
          BookWithEnum.Category.required);
    b.display();
    System.out.println();
    
    b.setCategory(BookWithEnum.Category.supplemental);
    b.display();
    System.out.println();
    
    b.setCategory("optional");
    b.display();
    System.out.println();
    
    BookWithEnum.Category category = b.getCategory();
    switch (category) {
    case required: 
      System.out.println(b.getTitle() + " is required.");
      break;
    case optional: 
      System.out.println(b.getTitle() + " is optional.");
      break;
    case supplemental: 
      System.out.println(b.getTitle() + " is a supplemental book.");
      break;
    case unknown: 
      System.out.println("Category for " + b.getTitle() + 
          " is not known at this time."); break;
    }
    System.out.println();
    
    StringBuilder categoryList = new StringBuilder("Categories:\n");
    for (BookWithEnum.Category cat : BookWithEnum.Category.values()) {
      categoryList.append("  ").append(cat.name()).append('\n');
    }
    System.out.println(categoryList); 
  }
}