import employees.*;
import finance.*;

public class Payroll {
  public static void main(String[] args) {

    Employee.setNextId(22);
    Employee e = new Employee("John", "Doe", 6000.0);
    
    // loop to pay each month
    for (int month = 0; month < 12; month++) {
      Employee.Payment p = e.createPayment();
      try {
        p.process();
        
        // HR error causes attempt to process June paycheck twice
        if (month == 5) p.process();
      }
      catch (TransactionException te) {
        System.out.println(te.getMessage());
      }
      System.out.println("Ytd pay: " + e.getYtdPay());
    }     
    
    System.out.println("Employee Payment History:");
    
    e.printPaymentHistory();
  }
  
}