public class BookWithEnum {
  private int itemCode;
  private String title;
  private double price;
  private Category category;
  
  public enum Category { required, supplemental, optional, unknown };
  
  public BookWithEnum(
        int itemCode, String title, 
        double price, Category category) {
    setItemCode(itemCode);
    setTitle(title);
    setPrice(price);
    setCategory(category);
  }
  public BookWithEnum(String title) {
    setItemCode(0);
    setTitle(title);
    setPrice(0.0);
    setCategory(Category.unknown);
  }
  public int getItemCode() {
    return itemCode;
  }
  public void setItemCode (int itemCode) {
    if (itemCode > 0) this.itemCode = itemCode; 
  }
  public String getTitle() {
    return title;
  }
  public void setTitle (String title) {
    this.title = title;
  }
  public void setPrice(double price) {
    this.price = price;
  }
  public double getPrice() {
    return price;
  }
  public void setCategory(Category category) {
    this.category = category;
  }
  public void setCategory(String categoryName) {
    this.category = Category.valueOf(categoryName);
  }
  public Category getCategory() {
    return category;
  }
  public void display() {
    System.out.println(itemCode + " " + title + ": " + category +
          ", Price: $" + price);
  }
}