public class ObjectMethods {
  int id;
  String name;
  int age;

  ObjectMethods(int id, String name, int age) {
    this.id = id;
    this.name = name;
    this.age = age;
  }
  public boolean equals(Object x) {
    if (x == this) {
      return true;
    }
    else if (x instanceof ObjectMethods) {
      ObjectMethods omx = (ObjectMethods) x;
      return id == omx.id && name.equals(omx.name) && age == omx.age;
    }
    else {
      return false;
    } 
  }
  public int hashCode() {
    return id + age * 1000;
  }
  public String toString() {
    return id + " " + name + " is " + age + " years old";
  }
  public Object clone() {
    return new ObjectMethods(id, name, age);
  }
  public static void main(String[] args) {
    ObjectMethods om1 = new ObjectMethods (1, "John", 6);
    ObjectMethods om2 = new ObjectMethods (1, "John", 6);
    ObjectMethods om3 = new ObjectMethods (2, "Jane", 5);
    ObjectMethods om4 = (ObjectMethods)om3.clone();
    System.out.println("Printing an object: " + om1);
    if (om1.equals(om2)) {
      System.out.println("om1 equals(om2)");
    }
    if (om1.equals(om3)) {
      System.out.println("om1 equals(om3)");
    }
    if (om1.equals("John")) {
      System.out.println("om1 equals(\"John\")");
    }
    if (om3.equals(om4)) {
      System.out.println("om3 equals(om4) which was cloned from om3");
    }
    System.out.println("object class is: " + om1.getClass());
  }
}