import java.io.IOException;
import java.util.logging.*;

public class Logging {	
  public static void main(String[] args) {
    Logger logMain = Logger.getLogger(Logging.class.getName());
    logMain.setLevel(Level.INFO);
    Logger logChild = 
      Logger.getLogger(Logging.class.getName() + ".debug");
    FileHandler fLogMainHandler = null, fLogChildHandler = null;
    Formatter fmtChild = new SimpleFormatter();
    try {
      fLogMainHandler = 
        new FileHandler("LoggingTestMain.log");
      fLogMainHandler.setLevel(Level.INFO);
      logMain.addHandler(fLogMainHandler);
      fLogChildHandler =
        new FileHandler("LoggingTestChild.%g.log", 300, 5);
      fLogChildHandler.setLevel(Level.ALL);
      logChild.addHandler(fLogChildHandler);
      fLogChildHandler.setFormatter(fmtChild);
      logMain.setLevel(Level.INFO);
      logChild.setLevel(Level.FINER);
    } catch (SecurityException e2) {
      e2.printStackTrace();
    } catch (IOException e2) {
      e2.printStackTrace();
    }

    logMain.info("Starting application ");
    for (int i = 0; i < 8; i++) {
      logChild.fine("Fine at iteration " + i);
      logChild.finer("Finer at iteration " + i);
      logChild.finest("Finest at iteration " + i);
      if (i == 4) try { System.in.read(); } catch (Exception e) { }
    }
    logMain.info("Ending application ");
    if (fLogMainHandler != null) fLogMainHandler.close();
    if (fLogChildHandler != null) fLogChildHandler.close();

  }
}