import employees.*;
import vendors.*;
import util.*;
import finance.*;
import java.util.*;

public class Payroll {	
  public static void main(String[] args) {
    List<Employee> e = new ArrayList<Employee>();
    Employee empl = null;
    String fName = null;
    String lName = null;
    int dept = 0;
    double payRate = 0.0;
    double hours = 0.0;

    for (int i = 0; i < 5; i++) {
      try {
         char type = 
          KeyboardReader.getPromptedChar("Enter type: E, N, or C: ");
        if (type != 'e' && type != 'E' && 
            type != 'n' && type != 'N' && 
            type != 'c' && type != 'C') {
          System.out.println("Please enter a valid type");
          i--;
          continue; 			 
        }
        fName = KeyboardReader.getPromptedString("Enter first name: ");
        lName = KeyboardReader.getPromptedString("Enter last name: ");
        dept = KeyboardReader.getPromptedInt(
              "Enter department: ", "Department must be numeric",
              new DeptValidator(), "Valid departments are 1 - 5");
        do {
          payRate = KeyboardReader.getPromptedDouble("Enter pay rate: ", 
                  "Pay rate must be numeric");
          if (payRate < 0.0) System.out.println("Pay rate must be >= 0");
        } while (payRate < 0.0);
  
        switch (type) {
          case 'e':
          case 'E': 
            empl = new ExemptEmployee(fName, lName, dept, payRate);
            e.add(empl);
            break;
          case 'n':
          case 'N': 
            do {
              hours = KeyboardReader.getPromptedDouble("Enter hours: ");
              if (hours < 0.0) 
                System.out.println("Hours must be >= 0");
            } while (hours < 0.0);
            empl = new NonexemptEmployee(fName,lName,dept,payRate,hours);
            e.add(empl);
            break;
          case 'c':
          case 'C': 
            do {
              hours = KeyboardReader.getPromptedDouble("Enter hours: ");
              if (hours < 0.0) 
                System.out.println("Hours must be >= 0");
            } while (hours < 0.0);
            empl = new ContractEmployee(fName,lName,dept,payRate,hours);
            e.add(empl);
        }
 
        System.out.println(empl.getPayInfo());
      } catch (InvalidValueException ex) {
          System.out.println(ex.getMessage());
          i--;	//failed, so back up counter to repeat this employee
        }
    }
   
    System.out.println();
    System.out.println("Exempt Employees");
    System.out.println("====== =========");
    for (Employee emp : e) {
      if (emp instanceof ExemptEmployee) {
        System.out.println(emp.getPayInfo());
      }
    }
    System.out.println();
    System.out.println("Nonexempt Employees");
    System.out.println("======== =========");
    for (Employee emp : e) {
      if (emp instanceof NonexemptEmployee) {
        System.out.println(emp.getPayInfo());
      }
    }
    System.out.println();
    System.out.println("Contract Employees");
    System.out.println("======== =========");
    for (Employee emp : e) {
      if (emp instanceof ContractEmployee) {
        System.out.println(emp.getPayInfo());
      }
    }

    List<Invoice> inv = new Vector<Invoice>();
    inv.add(new Invoice("ABC Co.", 456.78));
    inv.add(new Invoice("XYZ Co.", 1234.56));
    inv.add(new Invoice("Hello, Inc.", 999.99));
    inv.add(new Invoice("World, Ltd.", 0.43));

    List<Payable> payments = new ArrayList<Payable>();
    payments.addAll(e);
    payments.addAll(inv);

    CheckPrinter.printChecks( payments.toArray(new Payable[] { }) );

  }
}