import employees.*;
import vendors.*;
import util.*;
import finance.*;

public class Payroll
{
    public static void main (String[] args)
    {
        Employee[] e = new Employee[5];
        String fName = null;
        String lName = null;
        int dept = 0;
        double payRate = 0.0;
        double hours = 0.0;

        for (int i = 0; i < e.length; i++)
        {
            try
            {
                char type = KeyboardReader.getPromptedChar ("Enter type: E, N, or C: ");
                if (type != 'e' && type != 'E' && type != 'n' && type != 'N' && type != 'c' && type != 'C')
                {
                    System.out.println ("Please enter a valid type");
                    i--;
                    continue;
                }
                fName = KeyboardReader.getPromptedString ("Enter first name: ");
                lName = KeyboardReader.getPromptedString ("Enter last name: ");
                dept = KeyboardReader.getPromptedInt ("Enter department: ",
                    "Department must be numeric", new DeptValidator (),
                    "Valid departments are 1 - 5");
                payRate = KeyboardReader.getPromptedDouble (
                    "Enter pay rate: ", "Pay rate must be numeric", 
                    new PayRateValidator(), "Pay rate must be >= 0");

                switch (type)
                {
                    case 'e':
                    case 'E':
                        e[i] = new ExemptEmployee (fName, lName, dept, payRate);
                        break;
                    case 'n':
                    case 'N':
                        do
                        {
                            hours = KeyboardReader.getPromptedDouble (
                                "Enter hours: ", "Hours must be numeric");
                            if (hours < 0.0)
                                System.out.println ("Hours must be >= 0");
                        }
                        while (hours < 0.0);
                        e[i] = new NonexemptEmployee (fName, lName, dept, payRate, hours);
                    break;
                    case 'c':
                    case 'C':
                        do
                        {
                            hours = KeyboardReader.getPromptedDouble (
                                "Enter hours: ", "Hours must be numeric");
                            if (hours < 0.0)
                                System.out.println ("Hours must be >= 0");
                        }
                        while (hours < 0.0);
                        e[i] = new ContractEmployee (fName, lName, dept, payRate, hours);
                }

                System.out.println (e[i].getPayInfo ());
            }
            catch (InvalidValueException ex)
            {
                System.out.println (ex.getMessage ());
                i--; //failed, so back up counter to repeat this employee
            }
        }

        System.out.println ();
        System.out.println ("Exempt Employees");
        System.out.println ("====== =========");
        for (Employee emp : e)
        {
            if (emp instanceof ExemptEmployee)
            {
                System.out.println (emp.getPayInfo ());
            }
        }
        System.out.println ();
        System.out.println ("Nonexempt Employees");
        System.out.println ("======== =========");
        for (Employee emp : e)
        {
            if (emp instanceof NonexemptEmployee)
            {
                System.out.println (emp.getPayInfo ());
            }
        }
        System.out.println ();
        System.out.println ("Contract Employees");
        System.out.println ("======== =========");
        for (Employee emp : e)
        {
            if (emp instanceof ContractEmployee)
            {
                System.out.println (emp.getPayInfo ());
            }
        }

        Invoice[] inv = new Invoice[4];
        inv[0] = new Invoice ("ABC Co.", 456.78);
        inv[1] = new Invoice ("XYZ Co.", 1234.56);
        inv[2] = new Invoice ("Hello, Inc.", 999.99);
        inv[3] = new Invoice ("World, Ltd.", 0.43);

        CheckPrinter.printChecks (e);
        CheckPrinter.printChecks (inv);
    }
}
