import employees.*;
import util.*;

public class Payroll {	
  public static void main(String[] args) {
    Employee[] e = new Employee[5];
    String fName = null;
    String lName = null;
    int dept = 0;
    double payRate = 0.0;

    for (int i = 0; i < e.length; i++) {
      fName = KeyboardReader.getPromptedString("Enter first name: ");
      lName = KeyboardReader.getPromptedString("Enter last name: ");
      do {
        dept = KeyboardReader.getPromptedInt("Enter department: ");
        if (dept <= 0) System.out.println("Department must be >= 0");
      } while (dept <= 0);
      do {
        payRate = KeyboardReader.getPromptedDouble("Enter pay rate: ");
        if (payRate < 0.0) System.out.println("Pay rate must be >= 0");
      } while (payRate < 0.0);
      e[i] = new Employee(fName, lName, dept, payRate);
      System.out.println(e[i].getPayInfo());
    }

    lName = KeyboardReader.getPromptedString("Enter last name to find: ");
    boolean notFound = true;
    for (int i = 0; i < e.length; i++) {
      if (lName.equalsIgnoreCase(e[i].getLastName())) {
        System.out.println("Found: " + e[i].getPayInfo());
        notFound = false;
        break;
      }
    }
    if (notFound) System.out.println("Not found");
  }
}