import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;

public class TestLocalization {
    public static void main(String[] args) {
        /*
            First, let's find out the default locale
        */
        Locale defLocale = Locale.getDefault();
        System.out.println("Default language is " + defLocale.getLanguage() +
                " and default country is " + defLocale.getCountry());
        /*
            Use message bundles to adapt to locale languages
        */
        Locale frLocale = new Locale("fr", "FR");
        ResourceBundle frBundle = ResourceBundle.getBundle("MsgBundle", frLocale);
        System.out.println("France greeting: " + frBundle.getString("greeting") + " farewell: " + 
            frBundle.getString("farewell"));
        String[] languages = {"en", "fr", "it", "en"};
        String[] countries = {"US", "FR", "IT", "GB"};
        for (int i=0; i<languages.length; i++) {
            Locale locale = new Locale(languages[i], countries[i]);
            ResourceBundle resBundle =  ResourceBundle.getBundle("MsgBundle", locale);
            System.out.println(countries[i] + ": " + resBundle.getString("greeting") + "\t" + resBundle.getString("farewell"));
        }
        /*
            Display number based on locale
        */
        NumberFormat frNumberFormat = NumberFormat.getNumberInstance(new Locale("fr", "FR"));
        System.out.println("France number format: " + frNumberFormat.format(35_043.29));
        NumberFormat defaultNumberFormat = NumberFormat.getNumberInstance();
        System.out.println("Default locale number format: " + defaultNumberFormat.format(35_043.29));
        /*
            Display currency based on locale
        */
        NumberFormat gbCurrencyFormat = NumberFormat.getCurrencyInstance(new Locale("en", "GB"));
        System.out.println("Great Britain currency: " + gbCurrencyFormat.format(35_043.29));
        NumberFormat defCurrencyFormat = NumberFormat.getCurrencyInstance(new Locale("en", "US"));
        System.out.println("Default locale currency: " + defCurrencyFormat.format(35_043.29));
        /*
            Display date based on locale
        */
        GregorianCalendar gc = new GregorianCalendar();
        Date currentDate = gc.getTime();
        DateFormat frFormat = DateFormat.getDateInstance(DateFormat.FULL, Locale.FRANCE);
        System.out.println("Current date (France): " + frFormat.format(currentDate));
        DateFormat defFormat = DateFormat.getDateInstance(DateFormat.FULL);
        System.out.println("Current date (default): " + defFormat.format(currentDate));
    }
}