import java.time.*;
import java.time.format.*;
public class TestDateTimeAPI {
    public static void main (String args[]) {
        // Create a local date object:
        LocalDate dateToday=LocalDate.now();
        System.out.format("Current date is %s\n" , dateToday);

        // Format local date object:
        DateTimeFormatter formatDateToday=DateTimeFormatter.ofPattern("EEEE MMM dd, yyyy");
        System.out.format("Formatted current date is %s\n" , dateToday.format(formatDateToday));

        // Create a local time object:
        LocalTime timeNow=LocalTime.now();
        System.out.format("Current time is %s\n", timeNow);

        // Format local time object:
        DateTimeFormatter formatTimeNow=DateTimeFormatter.ofPattern("HH:mm:ss a");
        System.out.format("Formatted current time is %s\n", timeNow.format(formatTimeNow));

        // Create a local date time object:
        LocalDateTime today=LocalDateTime.now();
        System.out.format("Current date and time is %s\n", today);

        // Format local date time object:
        DateTimeFormatter formatToday=DateTimeFormatter.ofPattern("MM/dd/yy hh:mm:ss");
        System.out.format("Formatted date time is %s\n", today.format(formatToday));

        // Create a zoned date time object with current date and time and New York time zone ID:
        DateTimeFormatter formatTodayWithZoneId=DateTimeFormatter.ofPattern("MM/dd/yy hh:mm:ss VV");
        LocalDateTime currentDate=LocalDateTime.now();
        ZoneId timeZone=ZoneId.of("America/New_York");
        ZonedDateTime todayWithTimeZone=ZonedDateTime.of(currentDate, timeZone);
        System.out.format("Formatted date time with zone ID of New York is %s\n", todayWithTimeZone.format(formatTodayWithZoneId));

        // Using a Period object, find out the number of years, months and days between the current date and March 16, 1955 :
        LocalDate myBirthDate = LocalDate.of(1955, 3, 16);
        System.out.format("Month value of March is %d\n" , myBirthDate.getMonthValue());
        Period age = Period.between(myBirthDate, dateToday);
        System.out.format("My age is %d years, %d months, and %d days.\n",
                age.getYears(), age.getMonths(), age.getDays());

    }
}