/* Log Messages */
function log(msg) {
  const log = $('section#log>ol');
  const newItem = $("<li></li>");
  const now = new Date();
  newItem.html(now.toLocaleTimeString() + ': <em>' + msg + '</em>');
  log.append(newItem);
}

/* Remove item from list */
function removeFromList(e) {
  const item = $(e.target).parent();
  item.remove();
  const title = item.attr('title');
  log(title + ' removed.');

  const selector = `#common-items>button[name="${title}"]`;
  console.log(selector);
  const btnMatch = $(selector);
  if (btnMatch) {
    btnMatch.prop('disabled', false);
  }
}

/* Add product to list */
function addToList(product) {
  product = $.trim(product);
  
  const activeList = $('#active-items-list');
  const newItem = $('<li></li>');
  newItem.attr("title", product);
  newItem.html(product);
  newItem.addClass(
    'list-group-item d-flex justify-content-between align-items-center py-1'
  );
  activeList.append(newItem);
  log(product + ' added.');

  const btnRemove = $('<button class="btn btn-sm btn-danger">X</button>');
  btnRemove.on('click', removeFromList);
  newItem.append(btnRemove);

  // Check if list item being added is in common list items
  // If it is, we need to disable its button there.
  const selector = '#common-items>button[name="' + product + '"]';
  const btnMatch = $(selector);
  if (btnMatch) {
    btnMatch.prop('disabled', true);
  }
}

function init() {
  log('Page Loaded');
  const btnAddNewItem = $('#add-new-item');
  const cmnItemsButtons = $('#common-items>button');
  const newItem = $('#new-item');
  newItem.focus();

  /* Add event listeners to all common list Add buttons */
  cmnItemsButtons.on('click', function() {
    addToList($(this).attr('name'));
    newItem.focus();
  })

  /* Add event listener to New Item Add button */
  btnAddNewItem.on('click', function() {
    addToList(newItem.val());
    newItem.val('');
    newItem.focus();
  });

  /* 
    Add event listener capturing Enter press while
    focus is on New Item field 
  */
  newItem.on('keyup', function(e) {
    if (e.key === 'Enter') {
      addToList(newItem.val());
      newItem.val('');
      newItem.focus();
    }
  });
}

$(init);