/* Log Messages */
function log(msg) {
  const log = $('section#log>ol');
  const newItem = $("<li></li>");
  const now = new Date();
  newItem.html(now.toLocaleTimeString() + ': <em>' + msg + '</em>');
  log.append(newItem);
}

/* Remove item from list */
function removeFromList(e) {
  log('Item Removed');
}

/* Add product to list */
function addToList(product) {
  log(product + ' added.');
}

function init() {
  log('Page Loaded');
  const btnAddNewItem = $('#add-new-item');
  const cmnItemsButtons = $('#common-items>button');
  const newItem = $('#new-item');
  newItem.focus();

  /* Add event listeners to all common list Add buttons */
  cmnItemsButtons.on('click', function() {
    addToList($(this).attr('name'));
    newItem.focus();
  })

  /* Add event listener to New Item Add button */
  btnAddNewItem.on('click', function() {
    addToList(newItem.val());
    newItem.val('');
    newItem.focus();
  });

  /* 
    Add event listener capturing Enter press while
    focus is on New Item field 
  */
  newItem.on('keyup', function(e) {
    if (e.key === 'Enter') {
      addToList(newItem.val());
      newItem.val('');
      newItem.focus();
    }
  });
}

$(init);