#include <array>
#include <iostream>
#include <format>
#include <stdexcept>
#include <string>

typedef std::string str;

const double START_BALANCE = 0.0; // Initial account balance
double balance = START_BALANCE;   // User's account balance
str userInput;

struct Account {
    int acctNbr;
    str holder;
    double balance;
    
    enum class AcctType {
        Checking,
        Savings
    };

    AcctType acctType;
};

str displayAcctType(Account::AcctType acctType) {
    switch (acctType) {
    case Account::AcctType::Checking:
        return "Checking";
    case Account::AcctType::Savings:
        return "Savings";
    default:
        return "Invalid Account Type";
    }
}

void printAccountStruct(Account& account) {
    std::cout << std::format("{:^70}\n", "Bank Account Report");
    std::cout << std::format("{:<15} {:<20}\n", "Account Number", account.acctNbr);
    std::cout << std::format("{:<15} {:<20}\n", "Account Holder", account.holder);
    std::cout << std::format("{:<15} {:<20}\n", "Account Type", displayAcctType(account.acctType));
    std::cout << std::format("{:<15} ${:<20.2f}\n", "Balance", account.balance);
}

double withdraw(double amount) {
    static int nbrOfWithdrawals = 1;
    if (amount > balance) {
        std::string error_msg = std::format("Withdrawal rejected: amount ${:.2f} exceeds balance.\n", amount);
        throw std::runtime_error(error_msg);
    }
    else if (amount <= 0) {
        std::string error_msg = std::format("Withdrawal rejected: amount ${:.2f} is less than or equal to zero.\n", amount);
        throw std::runtime_error(error_msg);
    }
    else {
        std::cout << std::format("Number of withdrawals is now {}\n", nbrOfWithdrawals);
        if (nbrOfWithdrawals > 3) {
            amount += 3;
        }
        nbrOfWithdrawals++;
        return balance -= amount;
    }
}

double deposit(double amount) {
    if (amount <= 0) {
        std::string error_msg = std::format("Deposit rejected: amount ${:.2f} is less than or equal to zero.\n", amount);
        throw std::runtime_error(error_msg);
    }
    else {
        return balance += amount;
    }
}

int main() {
    //Allocate memory for the struct
    Account account;

    std::array<double, 100> depositLog{};
    int depositIndex = 0;
    std::array<double, 100> withdrawalLog{};
    int withdrawalIndex = 0;

    account.acctNbr = 555666777;
    // prompt user for account holder name 
    std::cout << "Please enter account holder name: ";
    getline(std::cin, userInput);
    account.holder = userInput;
    
    bool correct = false;
    // prompt user for the account type
    while (!correct && userInput[0] != 'Q') {
        std::cout << "Enter \'C\' for Checking or \'S\' S for Savings (Q to quit): ";
        getline(std::cin, userInput);
        switch (userInput[0]) {
        case 'C':
        case 'c':
            account.acctType = Account::AcctType::Checking;
            correct = true;
            break;
        case 'S':
        case 's':
            account.acctType = Account::AcctType::Savings;
            correct = true;
            break;
        case 'Q':
        case 'q':
            std::cout << "Banking menu will end...\n";
            correct = true;
            break;
        default:
            std::cout << "Unknown accout type...please re-enter (Q to quit).\n";
        }
        if (userInput[0] == 'q' || userInput[0] == 'Q') {
            return 0;
        }
    }

    do {
        // Display menu options
        std::cout << "\n Deposit (d)\n";
        std::cout << " Withdraw (w)\n";
        std::cout << " Balance (b)\n";
        std::cout << " Quit (q)\n\n";
        std::cout << "Enter choice: ";
        std::getline(std::cin, userInput);
        switch (userInput[0]) {
            // Handle deposit
            case 'd':
            case 'D': {
                double amount;
                std::cout << "Enter amount to deposit: ";
                std::getline(std::cin, userInput);
                try {
                    amount = std::stod(userInput);
                    balance = deposit(amount);
                    depositLog[depositIndex++] = amount;
                    std::cout << std::format("Deposited ${:.2f}\n", amount);
                }
                catch (std::invalid_argument& ie) {
                   std::cout <<  "Deposit amount must be numeric, amount rejected.\n";
                }
                catch (std::runtime_error& re) {
                   std::cout << re.what();
                }
                break;
            }
            // Handle withdrawal
            case 'w':
            case 'W': {
                double amount;
                std::cout << "Enter withdrawal amount: ";
                std::getline(std::cin, userInput);
                try {
                    amount = std::stod(userInput);
                    balance = withdraw(amount);
                    withdrawalLog[withdrawalIndex++] = amount;
                    std::cout << std::format("Withdrew ${:.2f}\n", amount);
                }
                catch (std::invalid_argument& ie) {
                   std::cout <<  "Withdrawal amount must be numeric, amount rejected.\n";
                }
                catch (std::runtime_error rte) {
                    std::cout << rte.what();
                }    
                break;
            }
            // Display balance
            case 'b':
            case 'B':
                std::cout << std::format("Current balance: ${:.2f}\n", balance);
                break;
            // Handle quit
            case 'q':
            case 'Q':
                std::cout << std::format("Final balance: ${:.2f}\n", balance);
                break;
            // Handle invalid input
            default:
                std::cout << "Invalid selection. Please choose a valid option.\n";
        }

    } while (userInput[0] != 'q' && userInput[0] != 'Q');
    // print withdrawal log
    std::cout << std::format("{:^20}\n", "Log of Withdrawals");
    for (auto& withdrawal : withdrawalLog) {
        if (withdrawal == 0) {
            break;
        }
        std::cout << std::format("{:>20}\n", std::format("${:.2f}",withdrawal));
    }
    // print deposit log
    std::cout << std::format("{:^20}\n", "Log of Deposits");
    for (auto& deposit : depositLog) {
        if (deposit == 0) {
            break;
        }
        std::cout << std::format("{:>20}\n", std::format("${:.2f}",deposit));
    }
    // set the balance in the account struct
    account.balance = balance;
    // print account struct
    printAccountStruct(account);
}