#include <iostream>   // Required for std::cout
#include <string>     // Required for std::string

// typedef Examples

// Example 1: Simple type alias
typedef unsigned int uint;  // 'uint' is now an alias for 'unsigned int'

// Example 2: Using typedef with a struct
typedef struct {
    std::string name;   // Member to store student's name
    int age;            // Member to store student's age
    float gpa;          // Member to store student's GPA
} Student;              // 'Student' can now be used as a type

// Example 3: Naming struct and typedef the same
typedef struct StudentTag {
    int id;             // Student ID
    float gpa;          // Student GPA
} StudentAlias;         // Typedef name matches struct tag

// Modern C++ alternative using 'using'
using Student2 = struct { 
    std::string name; 
    int age; 
    float gpa; 
};

// enum Examples

// Example 1: Basic enum
enum Color { RED, GREEN, BLUE }; // RED=0, GREEN=1, BLUE=2

// Example 2: Days of the week
enum Day { Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday };

// Example 3: Enumerators with custom values
enum CustomColor { Red = 1, GreenCustom = 5, BlueCustom = 10 };

// Example 4: Combining typedef and enum
typedef enum {
    Low,       // 0
    Medium,    // 1
    High       // 2
} Priority;

// Example 5: Modern C++ enum class
enum class ModernColor {RED, GREEN, BLUE};

int main() {
    // Typedef Demo
    uint age = 25;  // Using typedef alias for unsigned int
    std::cout << "Age: " << age << '\n';

    Student s1 = {"Alex", 20, 3.8}; // Create and initialize a Student
    std::cout << s1.name << ", " 
              << s1.age << ", GPA: " 
              << s1.gpa << '\n';

    StudentAlias s2;   // Using struct tag and typedef
    s2.id = 101;
    s2.gpa = 3.5;
    std::cout << "Student ID: " << s2.id << ", GPA: " << s2.gpa << '\n';

    Student2 s3 = {"Jordan", 22, 3.9}; // Using modern 'using' typedef
    std::cout << s3.name << ", " 
              << s3.age << ", GPA: " 
              << s3.gpa << '\n';

    // Enum Demo
    Color c = BLUE; // Assign a basic enum
    std::cout << "Color BLUE has value: " << c << '\n';

    Day today = Wednesday; // Assign enum for day
    std::cout << "Today is day number: " << today << '\n'; // Prints 2

    CustomColor favColor = GreenCustom; // Custom enum value
    std::cout << "Favorite color code: " << favColor << '\n'; // Prints 5

    Priority task = Medium; // Typedef and enum
    std::cout << "Task priority: " << task << '\n'; // Prints 1

    ModernColor mc = ModernColor::BLUE; // enumeration is Scoped to class name (ModernColor)
    std::cout << "Modern enumeration for BLUE: " << static_cast<int>(mc) << '\n'; // Cast explicitly to int

    return 0;
}