#include <iostream>
#include <string>

int main() {

    // 1) Basic struct definition
    struct Student {           // Define a new struct type named "Student"
        std::string name;      // Member to store the student's name
        int age;               // Member to store age
        double gpa;            // Member to store GPA
    };

    // Creating a struct variable
    Student s1;
    s1.name = "Alex";  // Assign values to members
    s1.age = 19;
    s1.gpa = 3.8;

    std::cout << "Student: " << s1.name 
              << ", Age: " << s1.age 
              << ", GPA: " << s1.gpa << '\n';

    // Using another way to initialize a struct
    Student s2 = {"Jordan", 20, 3.5};  // List initialization
    std::cout << "Student: " << s2.name 
              << ", Age: " << s2.age 
              << ", GPA: " << s2.gpa << '\n';

    // 2) Struct with default member values
    struct Point {
        double x = 0.0;  // Default x
        double y = 0.0;  // Default y
    };

    Point p;  // Automatically x=0.0, y=0.0
    std::cout << "Point coordinates: (" << p.x << ", " << p.y << ")\n";

    // 3) Using pointers with structs
    struct Date {
        int day;
        int month;
        int year;
    };

    Date today = {25, 11, 2025};
    Date* ptr = &today;  // Pointer to the struct

    std::cout << "Today (dot operator): " << today.day << "/" << today.month << "/" << today.year << '\n';
    std::cout << "Today (arrow operator): " << ptr->day << "/" << ptr->month << "/" << ptr->year << '\n';

    // 4) typedef for simpler struct names
    typedef struct {
        char name[40];  // Fixed-size character array for name
        int age;
        float gpa;
    } StudentTypedef;    // 'StudentTypedef' can now be used as a type

    StudentTypedef s3 = {"Mika", 19, 3.8};
    std::cout << "StudentTypedef: " << s3.name << ", Age: " << s3.age << ", GPA: " << s3.gpa << '\n';

    // 5) Array of structs
    Student roster[3] = {
        {"Ana", 20, 3.7},   // roster[0]
        {"Bo", 19, 3.4},    // roster[1]
        {"Chen", 21, 3.9}   // roster[2]
    };

    // Loop through the array
    for (int i = 0; i < 3; i++) {
        std::cout << "Roster[" << i << "]: " 
                  << roster[i].name << ", GPA: " 
                  << roster[i].gpa << '\n';
    }

    // 6) Nested structs
    struct Time {
        int hours;
        int minutes;
        int seconds;
    };

    struct Video {
        std::string title;
        Time duration;  // Nested struct
    };

    Video v = {"Intro to Structs", {0, 7, 45}};
    std::cout << "Video: " << v.title 
              << ", Duration: " << v.duration.hours << "h:" 
              << v.duration.minutes << "m:" 
              << v.duration.seconds << "s\n";

    // 7) Input/Output with structs
    Student st;
    std::cout << "Enter student name, age, gpa: ";
    std::cin >> st.name >> st.age >> st.gpa;  // Read values into struct

    std::cout << "You entered: " << st.name 
              << " (" << st.age << ") GPA=" << st.gpa << '\n';

    // 8) Memory basics
    std::cout << "Size of Student struct: " 
              << sizeof(Student) << " bytes\n";

    // 9) Struct vs Class
    // Note:
    // - struct members are public by default
    // - class members are private by default
    // Structs are often simpler for grouping data without behavior

    return 0;
}