// StructuredProgramming.cpp 
//

#include <iostream>
#include <format>

typedef std::string str;

struct Course {
    str code;
    str title;
    int duration;
    float cost;

    enum class Category {
        Programming,
        Database,
        MobileDevice
    };

    Category category;
};

str displayCategory(Course::Category category) {
    switch (category) {
    case Course::Category::Programming:
        return "Programming";
    case Course::Category::Database:
        return "Database";
    case Course::Category::MobileDevice:
        return "MobileDevice";
    default:
        return "Invalid Category";
    }
}

void printStructByValue(Course course) {
    std::cout << std::format("{:^70}\n", "Print struct passed by value to this function");
    std::cout << std::format("{:<15} {:<20}\n", "Course Code received", course.code);
    // change Course Code:
    course.code = "JVA103";
    std::cout << std::format("{:<15} {:<20}\n", "Course Code modified", course.code);
    std::cout << std::format("{:<15} {:<20}\n", "Title", course.title);
    std::cout << std::format("{:<15} {:>20}\n", "Nbr of Days", course.duration);
    std::cout << std::format("{:<15} {:>20}\n", "Cost", course.cost);
    std::cout << std::format("{:<15} {:<20}\n\n", "Category", displayCategory(course.category));
}

void printStructByReference(Course& course) {
    std::cout << std::format("{:^70}\n", "Print struct passed by reference to this function");
    std::cout << std::format("{:<15} {:<20}\n", "Course Code received", course.code);
    // change Course Code:
    course.code = "JVA103";
    std::cout << std::format("{:<15} {:<20}\n", "Course Code modified", course.code);
    std::cout << std::format("{:<15} {:<20}\n", "Title", course.title);
    std::cout << std::format("{:<15} {:>20}\n", "Nbr of Days", course.duration);
    std::cout << std::format("{:<15} {:>20}\n", "Cost", course.cost);
    std::cout << std::format("{:<15} {:<20}\n\n", "Category", displayCategory(course.category));
}


int main() {
    //Allocate memory for the struct
    Course course;
    course.code = "CPP001";
    course.title = "Introduction to C++";
    course.duration = 5;
    course.cost = 1500.00F;

    // add enum 
    course.category = Course::Category::Programming;

    std::cout << std::format("{:<15} {:<20}\n", "Course Code", course.code);
    std::cout << std::format("{:<15} {:<20}\n", "Title", course.title);
    std::cout << std::format("{:<15} {:>20}\n", "Nbr of Days", course.duration);
    std::cout << std::format("{:<15} {:>20}\n", "Cost", course.cost);
    std::cout << std::format("{:<15} {:<20}\n\n", "Category", displayCategory(course.category));

    // pass the struct by value to a function for printing:
    printStructByValue(course);
    // print course code:
    std::cout << std::format("{:<15} {:<20}\n\n", "Course Code after pass by value ", course.code);
    // pass the struct by reference to a function for printing:
    printStructByReference(course);
    std::cout << std::format("{:<15} {:<20}\n\n", "Course Code after pass by reference ", course.code);
}