#include <iostream>
#include <string>

// Define a simple Student struct
struct Student {
    std::string name; // Student's name
    int age;          // Student's age
    float gpa;        // Student's GPA
};

// 1) Pass by Value
// Function receives a copy of the struct
void printStudent(Student s) {
    std::cout << "[Pass by value] "
              << s.name << ", " << s.age << ", GPA: " << s.gpa << '\n';
    s.age += 1; // This change affects only the copy, not the original
}

// 2) Pass by Reference
// Function receives a reference to the original struct
void celebrateBirthday(Student& s) {
    s.age += 1; // Original struct is updated
    std::cout << "[Pass by reference] Happy Birthday " 
              << s.name << "! Age now: " << s.age << '\n';
}

// 3) Pass by Const Reference
// Function reads struct without modifying it
void showStudent(const Student& s) {
    std::cout << "[Pass by const reference] "
              << s.name << ", " << s.age << ", GPA: " << s.gpa << '\n';
}

// 4) Pass Using Pointers
// Function receives a pointer to the struct
void increaseGPA(Student* s) {
    s->gpa += 0.1f; // Arrow operator to access members
    std::cout << "[Pass by pointer] " << s->name 
              << "'s new GPA: " << s->gpa << '\n';
}

int main() {
    // Create and initialize Student
    Student s1 = {"Alex", 20, 3.8};
    std::cout << "Age:" << s1.age << '\n'; 
    // --- Pass by value ---
    printStudent(s1); 
    std::cout << "Age after pass by value: " << s1.age << '\n'; // Age unchanged

    // --- Pass by reference ---
    celebrateBirthday(s1); 
    std::cout << "Age after pass by reference: " << s1.age << '\n'; // Age changed

    // --- Pass by const reference ---
    showStudent(s1); // Cannot modify inside function

    // --- Pass by pointer ---
    increaseGPA(&s1); // Pass address of struct
    std::cout << "Original GPA after pointer function: " << s1.gpa << '\n';
}