#include <vector>
#include <list>
#include <string>
#include <iostream>

int main() {
    // Vector Demo
    std::vector<std::string> fruits = { "Apples", "Pears", "Bananas", "Oranges" };

    std::cout << "Vector size: " << fruits.size() << "\n";
    std::cout << "Vector contents:\n";
    for (auto& fruit : fruits) {
        std::cout << fruit << "\n";
    }

    fruits.push_back("Lemons");             // add at end
    fruits.insert(fruits.begin(), "Limes"); // add at beginning
    fruits.erase(fruits.begin() + 1);       // remove item

    std::cout << "Vector in reverse:\n";
    for (auto iter = fruits.rbegin(); iter != fruits.rend(); ++iter) {
        std::cout << *iter << "\n";
    }

    // List Demo
    std::list<std::string> fruitsList = { "Apples", "Pears", "Bananas", "Oranges" };

    std::cout << "\nList size: " << fruitsList.size() << "\n";
    std::cout << "List contents:\n";
    for (auto& fruit : fruitsList) {
        std::cout << fruit << "\n";
    }

    fruitsList.push_back("Lemons");  // add at end
    fruitsList.push_front("Limes");  // add at beginning

    std::cout << "List in reverse:\n";
    for (auto iter = fruitsList.rbegin(); iter != fruitsList.rend(); ++iter) {
        std::cout << *iter << "\n";
    }
    std::cout << "\nEnd of Demo!";

    return 0;
}