#include <iostream>
#include <unordered_map>
#include <unordered_set>
#include <string>

int main() {
    // ---Unordered Map Demo---
    std::cout << "--- Unordered Map ---\n";

    // Key=City (string), Value=Population (int)
    std::unordered_map<std::string, int> cityPopulations = {
        { "New York", 8000000 },
        { "London", 9000000 }
    };
    cityPopulations["Tokyo"] = 14000000;
    
    // Access is quick, but iteration order is unpredictable
    for (auto const& [city, pop] : cityPopulations) {
        std::cout << city << ": " << pop << "\n";
    }
    // ---Unordered Set Demo---
    std::cout << "\n--- Unordered Set ---\n";
    std::unordered_set<int> uniqueIDs;
    
    uniqueIDs.insert(501);
    uniqueIDs.insert(100);
    uniqueIDs.insert(501); // Duplicate attempt
    
    std::cout << "Total unique IDs: " << uniqueIDs.size() << "\n"; // Output: 2
    
    // Fast check for membership
    if (uniqueIDs.count(100)) {
        std::cout << "ID 100 found successfully.\n";
    }

    return 0;
}