// StandardDataStructures.cpp 
//

#include <iostream>
#include <format>
#include <vector>
#include <list>
#include <map>
#include <set>
#include <algorithm>  // use for sort


int main() {
    // create and use a vector
    std::vector<std::string> fruits = { "Apples", "Pears", "Bananas", "Oranges" };

    // display the fruits
    std::cout << std::format("Vector size is {}\n", fruits.size());
    std::cout << "Vector contents at start.\n";
    for (auto& fruit : fruits) {
        std::cout << fruit << "\n";
    }
    // add "Lemons" to the end of the vector and then insert "Limes"
    // at the beginning
    fruits.push_back("Lemons");  // add to the end
    fruits.insert(fruits.begin(), "Limes");  // add to the beginning

    // display the fruits with "Limes" and "Lemons"
    std::cout << "Vector contents with \"Limes\" at beginning and \"Lemons\" at the end\n";
    for (auto& fruit : fruits) {
        std::cout << fruit << "\n";
    }
    // remove the 2nd item (which is now "Apples" from the vector:
    fruits.erase(fruits.begin() + 1);
    // display with "Apples" removed
    std::cout << "Vector contents with \"Apples\" removed.\n";
    for (auto& fruit : fruits) {
        std::cout << fruit << "\n";
    }
    std::cout << "Vector contents in reverse.\n";
    for (auto iter = fruits.rbegin(); iter != fruits.rend(); ++iter) {
        std::cout << *iter << "\n";
    }
    std::list<std::string> fruitsList = { "Apples", "Pears", "Bananas", "Oranges" };
    std::cout << std::format("List size is {}\n", fruitsList.size());
    std::cout << "List contents at start.\n";
    for (const auto& fruit : fruitsList) {
        std::cout << fruit << "\n";
    }

    // Add a fruit at beginning and end of the list
    fruitsList.push_back("Lemons");  // add "Lemons" at the end
    fruitsList.push_front("Limes"); // add "Limes" at the beginning
    std::cout << "List contents with fruits added.\n";
    for (auto& fruit : fruitsList) {
        std::cout << fruit << "\n";
    }
    std::cout << "List contents in reverse with fruits added.\n";
    for (auto iter = fruitsList.rbegin(); iter != fruitsList.rend(); ++iter) {
        std::cout << *iter << "\n";
    }
    fruitsList.remove("Apples");  // remove all "Apples" list elements
    std::cout << "List contents with  \"Apples\" removed.\n";
    for (auto& fruit : fruitsList) {
        std::cout << fruit << "\n";
    }

    // create a map with key fruit name and value quantity on hand
    std::map<std::string, int> fruitsMap = {
        { "Apples", 10}, {"Pears", 2}, {"Bananas", 3}, {"Oranges", 9}
    };
    // List the fruit name and quantity on hand for all fruits
    std::cout << "Map with key of fruit name and value quantity on hand.\n";
    for (auto& [fruit, qtyOnHand] : fruitsMap) {
            std::cout << std::format("Fruit: {} Quantity on Hand: {}\n", fruit, qtyOnHand);
    }
    // add "Lemons" with quanity on hand of 20
    fruitsMap["Lemons"] = 20;
    // update "Apples" with quantity on hand of 8
    fruitsMap["Apples"] = 8;
    // decrease quantity on hand for "Bananas" by 2
    fruitsMap["Bananas"] -= 2;
    std::cout << "Map with \"Lemons\" added and adjustments to quantity on hand for \"Apples\" and \"Bananas\".\n";
    for (auto& [fruit, qtyOnHand] : fruitsMap) {
        std::cout << std::format("Fruit: {} Quantity on Hand: {}\n", fruit, qtyOnHand);
    }
    // remove "Pears" from the map
    fruitsMap.erase("Pears");
    std::cout << "Map with \"Pears\" removed.\n";
    for (auto& [fruit, qtyOnHand] : fruitsMap) {
        std::cout << std::format("Fruit: {} Quantity on Hand: {}\n", fruit, qtyOnHand);
    }
// create a set to store fruits
    std::set<std::string> fruitsSet = { "Apples", "Pears", "Bananas", "Oranges" };
    std::cout << "Set with fruits.\n";
    for (auto& fruit : fruitsSet) {
        std::cout << fruit << "\n";
    }
    // Add "Lemons"
    fruitsSet.insert("Lemons");
    // Try adding "Apples", already in the set
    auto result = fruitsSet.insert("Apples");
    if (result.second) {
        std::cout << "Apples inserted!\n";
    }
    else {
        std::cout << "Apples is already in the set!\n";
    }
    // Remove \"Bananas\"
    fruitsSet.erase("Bananas");
    // Display the set with Lemons added and Bananas removed
    std::cout << "Fruits sets with \"Lemons\" added and \"Bananas\" removed\n";
    for (auto& fruit : fruitsSet) {
        std::cout << fruit << "\n";
    }

    // sort a vector in ascending order
    std::vector<std::string> fruitsToSort = {  "Pears", "Bananas", "Oranges", "Apples", "Lemons"};
    std::sort(fruitsToSort.begin(), fruitsToSort.end());
    std::cout << "Sorted fruits ascending\n";
    for (auto& fruit : fruitsToSort) {
        std::cout << fruit << "\n";
    }
    // sort a vector in descending order
    fruitsToSort = { "Pears", "Bananas", "Oranges", "Apples", "Lemons" };
    std::sort(fruitsToSort.begin(), fruitsToSort.end(), std::greater<>());
    std::cout << "Sorted fruits descending\n";
    for (auto& fruit : fruitsToSort) {
        std::cout << fruit << "\n";
    }
    // find "Bananas"
    fruits = { "Pears", "Bananas", "Oranges", "Apples", "Lemons", "Bananas"};
    auto iter = fruits.begin();
    bool found = false;
    while ( (iter = std::find(iter, fruits.end(), "Bananas") ) != fruits.end()) {
        std::cout << "Found " << *iter << " at " <<
            std::distance(fruits.begin(), iter) << "\n";
        found = true;
        ++iter;
    }
    if (!found) {
        std::cout << "Bananas not found.\n";
    }
    fruitsToSort = { "Pears", "Bananas", "Oranges", "Apples", "Lemons" };
    std::ranges::sort(fruitsToSort);  // ascending sort
    std::cout << "Sorted fruits using ranges:\n";
    for (auto& fruit : fruitsToSort) {
        std::cout << fruit << "\n";
    }
    fruitsToSort = { "Pears", "Bananas", "Oranges", "Apples", "Lemons" };
    std::ranges::sort(fruitsToSort, std::greater<>{}); // descending sort
    std::cout << "Sorted fruits descending using ranges:\n";
    for (auto& fruit : fruitsToSort) {
        std::cout << fruit << "\n";
    }
}


