// StacksQueuesAndDeques.cpp 
//

#include <iostream>

#include <stack>
#include <queue>
#include <deque>

#include <string>

int main() {
    // Create a stack that holds messages
    std::stack<std::string> messageStack;
    // Push items onto the stack in Last In First Out (LIFO) order
    messageStack.push("Market product.");
    messageStack.push("Get parts and assemble product.");
    messageStack.push("Design product.");

    // Pop and print items from the stack
    std::cout << "Printing messages on the stack:\n";
    while (!messageStack.empty()) {
        std::cout << messageStack.top() << '\n';
        messageStack.pop(); // remove the top element
    }

    // Create a queue
    std::queue<std::string> messageQueue;
    // Push items onto the queue in First In First Out (FIFO) order
    messageQueue.push("Design product.");
    messageQueue.push("Get parts and assemble product.");
    messageQueue.push("Market product.");
    std::cout << "\nPrinting messages on the queue:\n";
    while (!messageQueue.empty()) {
        std::cout << messageQueue.front() << "\n";
        messageQueue.pop(); // remove the front element
    }

    // Create a deque
    std::deque<std::string> messageDeque;
    // Push items like a queue
    messageDeque.push_back("Design product.");
    messageDeque.push_back("Get parts and assemble product.");
    messageDeque.push_back("Market product.");
    std::cout << "\nPrinting deque as a queue:\n";
    for (const auto& msg : messageDeque) {
        std::cout << msg << "\n";
        messageDeque.pop_front();  // remove the front item
    }
    // Empty the deque (not necessary if we pop items in the for loop above)
    //messageDeque.clear();
    // Push items like a stack
    messageDeque.push_front("Market product.");
    messageDeque.push_front("Get parts and assemble product.");
    messageDeque.push_front("Design product.");
    std::cout << "\nPrinting deque as a stack:\n";
    for (const auto& msg : messageDeque) {
        std::cout << msg << "\n";
    }

    





    return 0;
}