#include <iostream>
#include <stack>
#include <queue>
#include <deque>

int main() {
    // STACK (LIFO)
    std::stack<int> numberStack;

    numberStack.push(10);  // first
    numberStack.push(20);  // second
    numberStack.push(30);  // last pushed, first out

    std::cout << "STACK (LIFO):\n";
    while (!numberStack.empty()) {
        std::cout << numberStack.top() << "\n"; // prints last added item first
        numberStack.pop();
    }

    // QUEUE (FIFO)
    std::queue<int> numberQueue;

    numberQueue.push(100); // first
    numberQueue.push(200); // second
    numberQueue.push(300); // third

    std::cout << "\nQUEUE (FIFO):\n";
    while (!numberQueue.empty()) {
        std::cout << numberQueue.front() << "\n"; // prints oldest added item first
        numberQueue.pop();
    }

    // DEQUE (both ends open)
    std::deque<int> numberDeque;

    // Use it like a queue (push back, pop front)
    numberDeque.push_back(1);
    numberDeque.push_back(2);
    numberDeque.push_back(3);

    std::cout << "\nDEQUE as QUEUE:\n";
    while (!numberDeque.empty()) {
        std::cout << numberDeque.front() << "\n";
        numberDeque.pop_front();
    }

    // Use it like a stack (push front, pop front)
    numberDeque.push_front(7);
    numberDeque.push_front(8);
    numberDeque.push_front(9);

    std::cout << "\nDEQUE as STACK:\n";
    while (!numberDeque.empty()) {
        std::cout << numberDeque.front() << "\n";
        numberDeque.pop_front();
    }

    return 0;
}
