#include <iostream>
#include <map>
#include <set>
#include <string>

int main() {
    // ---Map Demo---
    std::cout << "--- Map Demo ---\n";
    std::map<int, std::string> employeeMap;

    // Insert values (key = ID, value = name)
    employeeMap[101] = "Sarah";
    employeeMap[205] = "Mark";

    // Updating existing key
    employeeMap[101] = "Sarah J.";
    std::cout << "ID 101 Name: " << employeeMap[101] << "\n";


    // ---Set Demo---
    std::cout << "\n--- Set Demo ---\n";
    std::set<double> uniqueNumbers;

    // Insert elements
    uniqueNumbers.insert(3.14);
    uniqueNumbers.insert(1.618);

    // Attempt to insert a duplicate
    auto insertResult = uniqueNumbers.insert(3.14);
    std::cout << "Total unique numbers: " << uniqueNumbers.size() << "\n";

    // Check if duplicate insertion failed
    if (insertResult.second == false) {
        std::cout << "3.14 was not added again (already exists).\n";
    }

    // Check if a value exists
    if (uniqueNumbers.count(1.618)) {
        std::cout << "1.618 is in the set.\n";
    }
    return 0;
}