#include <iostream>
#include <vector>
#include <string>
#include <algorithm>   // sort, find, ranges::sort
#include <functional>  // std::greater

int main() {
    // --- Sort Demo ---
    std::vector<std::string> fruits = {
        "Pears", "Bananas", "Oranges", "Apples", "Lemons"
    };

    // Ascending sort
    std::sort(fruits.begin(), fruits.end());
    std::cout << "--- Ascending Sort ---\n";
    for (auto& fruit : fruits) {
        std::cout << fruit << "\n";
    }

    // Descending sort
    fruits = { "Pears", "Bananas", "Oranges", "Apples", "Lemons" };
    std::sort(fruits.begin(), fruits.end(), std::greater<>());
    std::cout << "\n--- Descending Sort ---\n";
    for (auto& fruit : fruits) {
        std::cout << fruit << "\n";
    }

    // --- Find Demo ---
    std::vector<std::string> searchFruits = {
        "Pears", "Bananas", "Oranges", "Apples", "Lemons", "Bananas"
    };

    auto it = searchFruits.begin();
    std::cout << "\n--- Find All Occurrences of 'Bananas' ---\n";

    while ((it = std::find(it, searchFruits.end(), "Bananas")) != searchFruits.end()) {
        std::cout << "Found at index: "
                  << std::distance(searchFruits.begin(), it) << "\n";
        ++it; // move forward to keep searching
    }

    // --- Ranges Sort Demo ---
    std::vector<std::string> moreFruits = {
        "Pears", "Bananas", "Oranges", "Apples", "Lemons"
    };

    std::ranges::sort(moreFruits);
    std::cout << "\n--- Ranges Ascending Sort ---\n";
    for (auto& f : moreFruits) {
        std::cout << f << "\n";
    }

    std::ranges::sort(moreFruits, std::greater<>());
    std::cout << "\n--- Ranges Descending Sort ---\n";
    for (auto& f : moreFruits) {
        std::cout << f << "\n";
    }
    return 0;
}